function log2svg( z, logvalues, fnames, ftops, filename, logname )
% logvalues2svg( z, logvalues, fnames, ftops, filename )
% 
% Renders well logvalues data to an svg file
% z : vector of depth of log values
% logvalues : vector with log values
% fnames : cell array with formation top names
% ftops : depths of picked formation tops
% filename : name of svg file to write



exageration = 2;
% logvalues = logvalues*exageration;

fid = svgheader( filename, max(logvalues)+200, max(abs(z)) );

svgstartgroup(fid, 'main');

svgline( fid, logvalues * exageration, z, 'stroke', 'red', 'stroke_width', 2);

svgline( fid, [min(logvalues), min(logvalues)] * exageration, [min(z), max(z)] , 'stroke', 'black');    
svgline( fid, [max(logvalues), max(logvalues)] * exageration, [min(z), max(z)] , 'stroke', 'black');    

for idx = 1 : length( ftops ),
    svgline( fid, [min(logvalues), max(logvalues)] * exageration, repmat( ftops(idx), 1,2), 'stroke', 'blue', 'stroke_width', 2);    
    svglabels( fid, max(logvalues) * exageration , ftops(idx)  , cell2mat(fnames(idx )), 'fill', 'blue' );
end

% if round(z(1) /10)*10 == z(1),
%     zmin = z(1);
% else
%     zmin = 10 + round(z(1)/10)*10;
% end

zstep = 50;
zmin = ceil(  min(z) / zstep) * zstep;
zmax = floor( max(z) / zstep) * zstep;

% Vertical scale
for idx = zmin:zstep:zmax,
    svgline( fid, [min(logvalues), max(logvalues)] * exageration, [idx, idx], 'stroke', 'black');    
    svglabels( fid, min(logvalues * exageration) -5 - (7*length(num2str(idx))) , idx  , num2str(idx), 'font-size', 10, 'fill', 'black' );
end
% 
lstep = 10;
% lmin = ceil(  min(logvalues) / lstep ) * lstep;
% lmax = floor( max(logvalues) / lstep ) * lstep;

% horizontal scale
for idx = 0:25:100,
    svgline( fid, [idx, idx] * exageration, [zmin-zstep+1, zmin-zstep+4], 'stroke', 'black'); % add dash   
    svglabels( fid, (idx * exageration) - (3.3*length(num2str(idx))) , zmin-zstep, num2str(idx), 'font-size', 10, 'fill', 'black' );
end

svglabels( fid, min(logvalues * exageration) -30 , zmin-zstep-15, 'Z (m)', 'font-size', 10 );
svglabels( fid, min(logvalues * exageration) +30 , zmin-zstep-15, 'log', 'font-size', 10 );
svglabels( fid, max(logvalues * exageration) , zmin-zstep -15, 'Formation top', 'font-size', 10, 'fill', 'blue' );

svglabels( fid, min(logvalues * exageration) -30 , zmin-zstep-40, logname, 'font-size', 20 );
    
svgendgroup(fid);
svgfooter(fid);